<?php
/**
 * @file       multisitesid.php
 * @brief      System Plugin that allow Search a special keyword {{site_id}} that will be replaced
 *             by the current JMS site ID.
 *             This allow for example to fill a hidden field of a form with the current site ID.
 * @version    1.2.01
 * @author     Edwin CHERONT     (e.cheront@jms2win.com)
 *             Edwin2Win sprlu   (www.jms2win.com)
 * @copyright  Jms Multi Sites
 *             Single Joomla! 1.5.x, 2.5.x, 3.x installation using multiple configuration (One for each 'slave' sites).
 *             (C) 2008-2013 Edwin2Win sprlu - all right reserved.
 * @license    This program is free software; you can redistribute it and/or
 *             modify it under the terms of the GNU General Public License
 *             as published by the Free Software Foundation; either version 2
 *             of the License, or (at your option) any later version.
 *             This program is distributed in the hope that it will be useful,
 *             but WITHOUT ANY WARRANTY; without even the implied warranty of
 *             MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *             GNU General Public License for more details.
 *             You should have received a copy of the GNU General Public License
 *             along with this program; if not, write to the Free Software
 *             Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *             A full text version of the GNU GPL version 2 can be found in the LICENSE.php file.
 * @par History:
 * - V1.0.0 26-SEP-2009: File creation
 * - V1.1.0 29-MAY-2010: Add an alternate Multisites ID definition that can have a variant and that allow replacing the ":master_db:" 
                         parameter with another value and also give the possibility to add a dot after that site ID when the slave site id is present.
 * - V1.1.1 07-MAR-2011: Add Joomla 1.6 compatibility
 * - V1.2.0 25-NOV-2012: Add the possibility to replace some parts of the multisites id.
 * - V1.2.01 28-NOV-2013: Repackaging for Joomla 3.x
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.plugin.plugin' );


class plgSystemMultisitesID extends JPlugin
{

	var $_db = null;

	/**
	 * Constructor
	 *
	 * For php4 compatability we must not use the __constructor as a constructor for plugins
	 * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
	 * This causes problems with cross-referencing necessary for the observer design pattern.
	 *
	 * @access	protected
	 * @param	object	$subject The object to observe
	 * @param 	array   $config  An array that holds the plugin configuration
	 * @since	1.0
	 */
	function plgSystemMultisitesID(& $subject, $config)
	{
		parent :: __construct($subject, $config);
	}


	/**
     * Converting the site URL to fit to the HTTP request
     */
	function onAfterRender()
	{
		$app =& JFactory::getApplication();

		// If not called from the front-end
		if($app->getName() != 'site') {
			return true;
		}

      $site_id = defined( 'MULTISITES_ID') ? MULTISITES_ID : ':master_db:';

      $search  = array();
      $replace = array();
      
      // ------ Read Plugin Parameters ----
      $search[]   = $this->params->get("siteid_keyword", '{{site_id}}');
      $replace[]  = $site_id;

      $search[]   = $this->params->get("siteid_indomain", '{{site_id_indomain}}');
      $master_id  = $this->params->get("master_id", '');
      $add_dot    = $this->params->get("add_dot");
      
      $siteid_indomain = defined( 'MULTISITES_ID') ? MULTISITES_ID : $master_id;
      if ( !empty( $siteid_indomain) && !empty( $add_dot) && (int)$add_dot>0) {
         $siteid_indomain .= '.';
      }
      $replace[]  = $siteid_indomain;

		// ------ Compute the {{site_id-n}} keywords ----
      $site_id_pattern  = $this->params->get("siteid_nbr_keyword", '{{site_id-#}}');
		$site_id_search   = array();
		$site_id_replace  = array_reverse( explode( '.', $site_id));
		if ( !empty($site_id_replace) && is_array( $site_id_replace)) {
   		for ( $i=0; $i<count($site_id_replace); $i++) {
   		   $site_id_search[$i] = str_replace( '#', trim( (string)($i+1)), $site_id_pattern);
   		}
   	}


		$buffer = JResponse::getBody();
		$buffer = str_replace( $search, $replace, $buffer);
		$buffer = str_replace( $site_id_search, $site_id_replace, $buffer);
   
		JResponse::setBody($buffer);
		return true;
	}
} // End class
