#!/bin/bash
# Enable debugging trace
# set -x
# ------ Documentation -------
# Parameters
# $1 = backup name
# $2 = Joomla PHP Code directory
# $3 = DB user
# $4 = DB password
# $5 = FTP URL
# $6 = FTP User
# $7 = FTP Psw
# $8 = FTP remote directory where to save the file. A weekly subdirectory with the day name is automatically created.
# $9  = FTP#2 URL
# $10 = FTP#2 User
# $11 = FTP#2 Psw
# $12 = FTP#2 remote directory where to save the file. A weekly subdirectory with the day name is automatically created.

#EMAILID="email1@domain.com,email2@domain.com"
EMAILID=""

encpassword="MyEncyptionPassword123456890"

# Sample command
# ./backup_weekly.sh test /home/CPANEL_ACCOUNT/domains/jms2win.com/subdomains/master/public_html dbuser "DB-Password" ftp.yourdomain.com ftpuser ftppassword /backup/
# ./backup_weekly.sh test /home/CPANEL_ACCOUNT/domains/jms2win.com/subdomains/master/public_html dbuser "DB-Password" ftp.yourdomain.com ftpuser ftppassword
# ./backup_weekly.sh test /home/CPANEL_ACCOUNT/domains/jms2win.com/subdomains/master/public_html dbuser "DB-Password"

# -- Create the backup name corresponding to the day of the week
mkdir -p $PWD/weekly/`date +%A`/$1

# -- remove previous backup present in the directory
rm -f $PWD/weekly/`date +%A`/$1/*

# -- Backup ALL DB (without locking and force to continue in case of error)
backupdate=`date +%d-%b-%Y-%Hh%M`
mysqldump --all-databases --force --lock-tables=false -u$3 -p$4 -r$PWD/weekly/`date +%A`/$1/alldatabases-$backupdate.sql
datedb=`date +%d-%b-%Y-%Hh%M`
tar -cvzf $PWD/weekly/`date +%A`/$1/alldatabases_$datedb.tgz $PWD/weekly/`date +%A`/$1/alldatabases-$backupdate.sql
# encrypted tgz.enc
# tar -cvz $PWD/weekly/`date +%A`/$1/alldatabases-$backupdate.sql | openssl enc -aes-256-cbc -e -k $encpassword -out $PWD/weekly/`date +%A`/$1/alldatabases_$datedb.tgz.enc

# -- Backup PHP Code
datesites=`date +%d-%b-%Y-%Hh%M`
tar -cvzf $PWD/weekly/`date +%A`/$1/sites_$datesites.tgz $2
# Encrypted
# tar -cvz $2 | openssl enc -aes-256-cbc -e -k $encpassword -out $PWD/weekly/`date +%A`/$1/sites_$datesites.tgz.enc

# ----------------------------
# -- In case where you want to send the backup on another server by FTP

# When the FTP parameters are present, Send the file by FTP
set -x   
if [ $# -ge 7 ]
then
   lftp ftp://"$6":"$7"@$5 -e "set ftp:ssl-allow no; mkdir -p $8$1/`date +%Y`/`date +%m`/`date +%d`/`date +%Hh%M` ; mput -O $8$1/`date +%Y`/`date +%m`/`date +%d`/`date +%Hh%M` $PWD/weekly/`date +%A`/$1/*.tgz  ; quit"
   # Encrypted files (tgz.enc)
   # lftp ftp://"$6":"$7"@$5 -e "set ftp:ssl-allow no; mkdir -p $8$1/`date +%Y`/`date +%m`/`date +%d`/`date +%Hh%M` ; mput -O $8$1/`date +%Y`/`date +%m`/`date +%d`/`date +%Hh%M` $PWD/weekly/`date +%A`/$1/*.enc  ; quit"
fi

# Test second FTP connection
if [ $# -ge 11 ]
then
   ftpurl=$9
   ftpuser=${10}
   ftppsw=${11}
   ftpdir=${12}

   lftp ftp://"$ftpuser":"$ftppsw"@$ftpurl -e "set ftp:ssl-allow no; mkdir -p $ftpdir$1 ; cd $ftpdir$1; mrm *; put $PWD/weekly/`date +%A`/$1/alldatabases_$datedb.tgz -o alldatabases.tgz; put $PWD/weekly/`date +%A`/$1/sites_$datesites.tgz -o sites.tgz ; quit"
   # Encrypted
   # lftp ftp://"$ftpuser":"$ftppsw"@$ftpurl -e "set ftp:ssl-allow no; mkdir -p $ftpdir$1 ; cd $ftpdir$1; mrm *; put $PWD/weekly/`date +%A`/$1/alldatabases_$datedb.tgz.enc -o alldatabases.tgz.enc; put $PWD/weekly/`date +%A`/$1/sites_$datesites.tgz.enc -o sites.tgz.enc ; quit"
   lftp ftp://"$ftpuser":"$ftppsw"@$ftpurl -e "set ftp:ssl-allow no; cd $ftpdir$1; put $PWD/backupdone.txt; quit"
fi


#### DO NOT CHANGE anything BELOW ####
MAILCMD="$(which mail)"
mkdir -p $PWD/tmp
chmod 777 $PWD/tmp
MAILMESSAGE="$PWD/tmp/backup.notification.$$"

if [ "$EMAILID" = "" ]
then
   # do nothing (no email to send)
   echo "No email to send"
   rm -f $MAILMESSAGE 
else
   # Email notification
   echo "Backup shell script completed for : $1" >>$MAILMESSAGE
   echo "" >>$MAILMESSAGE
   echo "*** This email generated by $(basename $0) shell script ***" >>$MAILMESSAGE
   echo "*** Please don't reply this email, this is just notification email ***" >>$MAILMESSAGE
   # send email
   $MAILCMD -s "CRON::Backup of $1 completed" $EMAILID < $MAILMESSAGE
   rm -f $MAILMESSAGE 
fi
