<?php
/**
 * @file       hello.php
 * @brief      Small program to help the user the configuration of their DNS tools (CPanel, Plesk, ...).
 * @version    1.2.2
 * @author     Edwin CHERONT     (e.cheront@jms2win.com)
 *             Edwin2Win sprlu   (www.jms2win.com)
 * @copyright  Joomla Multi Sites
 *             Single Joomla! 1.5.x installation using multiple configuration (One for each 'slave' sites).
 *             (C) 2008 Edwin2Win sprlu - all right reserved.
 * @license    This program is free software; you can redistribute it and/or
 *             modify it under the terms of the GNU General Public License
 *             as published by the Free Software Foundation; either version 2
 *             of the License, or (at your option) any later version.
 *             This program is distributed in the hope that it will be useful,
 *             but WITHOUT ANY WARRANTY; without even the implied warranty of
 *             MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *             GNU General Public License for more details.
 *             You should have received a copy of the GNU General Public License
 *             along with this program; if not, write to the Free Software
 *             Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *             A full text version of the GNU GPL version 2 can be found in the LICENSE.php file.
 * @par History:
 * - V1.2.1 22-JUN-2011: Give the possibility to keep the temporary files.
 *                       So that, it is possible to check the ownership of the file.
 *                       Also try detect if the symbolic link is allowed under Windows platform.
 *                       Some windows platform may accept the symbolic link (Windows 7, Server 2008, ...)
 * - V1.2.2 26-JAN-2013: Add the display of the domain name in case where international characters are present.
 */


function write_file_content( $filename, $content)
{
   $fp = fopen( $filename, "w");
   if ( !empty( $fp)) {
      fputs( $fp, $content);

//      echo '<br/>F Stat info :' . var_export( fstat( $fp), true) . '<br/>';

      fclose( $fp);

      echo "<br/>Temporary file [$filename] can be written<br />";

      if ( !empty( $_REQUEST['debug']) && $_REQUEST['debug']=='on') {
         if ( file_exists( $filename)) {
            echo "Temporary file [$filename] EXISTS<br />";
            echo "its content = <br/>";
            echo $content;
         }
         else {
            echo "Temporary file [$filename] DOES NOT EXISTS<br />";
         }
         @include $filename;
      }

      return true;
   }
   return false;
}

//------------ getServerOwner ---------------
function getServerOwner()
{
   $return = -2;
   
	$tmp = uniqid('hello_owner_') . '.txt';;
	$ssp = ini_get('session.save_path');
	$jtp = getcwd() .DIRECTORY_SEPARATOR.'tmp';
	$cur = getcwd();
	$content = '<' . "?php\n"
	         . 'echo "tmp file user : " . get_current_user() . "<br/>";' . "\n"
	         . '?' . ">\n";
	$content = 'this file can be deleted';

	// Try to find a writable directory
	$dir = write_file_content( "/tmp/$tmp", $content) ? '/tmp' : false;
//	echo '<br/>test TMP ====> ' . $dir;
	if ( $dir === false) { if ( write_file_content( "$ssp/$tmp", $content)) { $dir = $ssp; }}
//	echo "<br/>test ssp[$ssp] ====> " . $dir;
	if ( $dir === false) { if ( write_file_content( "$jtp/$tmp", $content)) { $dir = $jtp; }}
//	echo "<br/>test jtp[$jtp] ====> " . $dir;
	if ( $dir === false) { if ( write_file_content( "$cur/$tmp", $content)) { $dir = $cur; }}
//	echo "<br/>test cur[$cur] ====> " . $dir;



	if (($dir !== false))
	{
      $return = -1;
		$test = $dir.DIRECTORY_SEPARATOR.$tmp;

/*

		// Create the test file
      $fp = fopen( $test, "w");
      if ( empty( $fp)) {
         fputs( $fp, 'this file can be deleted');
         fclose( $fp);

      }
      else {
         echo "<br/>Unable to create temporary file [$test]<br />";
      }
*/

		// Test ownership
		$return = fileowner($test);
		
//		echo "<br/>file owner [$test] = " . fileowner($test) . '<br/>';
//		echo var_export( $return, true);
//      echo '<br/>Stat info :' . var_export( stat( $test), true) . '<br/>';
      
      // Try change owner ID
      chmod( $test, 0777);
//      chown( $test, get_current_user());
      chown( $test, getmyuid());
      
      chgrp( $test, getmygid ());
		
		// Delete the test file
      if ( file_exists( $test)) {
         unlink( $test);
      }
	}

	return $return;
}

//------------ hello_word ---------------
function hello_word()
{
   $cur_dir = getcwd();
?>
<h2>Hello world script</h2>
<table border="1"  cellspacing="0" cellpadding="3">
<tr bgcolor="#FFFFC0">
   <td colspan="2" align="center">hello world script</td>
</tr>   
<tr>
   <td align="right">Domain</td>
   <td><font color="blue" size="4">"<?php echo $_SERVER['HTTP_HOST']; ?>"</font></td>
</tr>   
<tr>
   <td align="right">The current path is</td>
   <td><font color="blue" size="4">"<?php echo $cur_dir; ?>"</font></td>
</tr>   
<?php   
   // If PHP < 5.3 and Windows
   if ( version_compare( phpversion(), '5.3') < 0
     && strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
      echo '<tr><td align="right">Platform :</td><td>Windows<br/>'
          . 'PHP Version = '.phpversion() .'<br/>'
          . 'In this case the Symbolic Link feature is not available.</td></tr>';
   }
   // If Unix or Windows (Vista, Win 7, Server 2008, 2010)
   else {
      // Test Symbolic Links
      $tmp_fname = $cur_dir .DIRECTORY_SEPARATOR. uniqid('symlink_file') . '.txt';
      $fp = fopen( $tmp_fname, "w");
      if ( empty( $fp)) {
         $env_open_basedir = ini_get('open_basedir');
         $env_safe_mode    = ini_get('safe_mode');
         echo "<tr><td>Error :</td>";
         echo "<td>Unable to create the file $tmp_fname<br/>"
             . "Probably you will need to used the Joomla FTP Layer and the Symbolic Links will be forbidden<br/>";
         if ( !empty( $env_open_basedir)) {
            echo 'We also detected that <font color="red">open_basedir is enabled</font>. The symbolic links might be limited to following directories.<br/>';
         }
         echo "</td></tr>";
         if ( !empty( $env_open_basedir)) {
            echo '<tr><td valign="top">open_basedir :</td><td>' . str_replace( ':', '<br />', $env_open_basedir) . '</td></tr>';
         }
         if ( !empty( $env_safe_mode)) {
//            echo 'We also detected that <font color="red">env_safe_mode is enabled</font>. The symbolic links might be limited to following directories.<br/>';
         }
         echo '<tr><td valign="top">env_safe_mode :</td><td>' . var_export( stat( $env_safe_mode), true) . '</td></tr>';
         echo '<tr><td valign="top">hello  owner name :</td><td>' . get_current_user() . '</td></tr>';
         echo '<tr><td valign="top">hello  owner ID :</td><td>' . getmyuid() . '</td></tr>';
         echo '<tr><td valign="top">hello  group ID :</td><td>' . getmygid();
              if ( function_exists( 'posix_getgrgid')) {
                  $groupid   = getmygid();
                  $groupinfo = posix_getgrgid($groupid);
                  if ( !empty( $groupinfo['name'])) {
                     echo ' (' . $groupinfo['name'] . ')';
                  }
              }
         echo '</td></tr>';
         $server_owner_id = getServerOwner();
         echo '<tr><td valign="top">Server owner ID :</td><td>' . $server_owner_id;
              if ( function_exists( 'posix_getpwuid')) {
                  $userinfo = posix_getpwuid( $server_owner_id);
                  if ( !empty( $userinfo['name'])) {
                     echo ' (' . $userinfo['name'] . ')';
                  }
              }

         echo '</td></tr>';
      }
      else {
         fputs( $fp, 'this file can be deleted');
         fclose( $fp);
         
         // Check that temporary file exists
         if ( file_exists( $tmp_fname)) {
            $link = uniqid('symlink');
         
         }
      
         if ( !function_exists( 'symlink')) {
            echo '<tr><td align="right">Platform :</td><td>Symbolic Link function is not available on this environment.<br/>';
            if ( strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
               echo 'On Windows platform, the symbolic link is only available when using PHP 5.3 or higher AND Windows Vista, Windows 7, Server 2008 or higher<br/>'
                  . 'PHP Version = '.phpversion()
                  ;
            }
            else {
               echo 'Platform is ' .PHP_OS. '<br/>'
                  . 'PHP Version = '.phpversion() .'<br/>'
                  ;
            }
            echo '</td></tr>';
         }
         // If link failed on the log path
         else if ( !symlink( $tmp_fname, $link)) {
            if ( strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
               echo '<tr><td align="right">Platform :</td><td>Windows platfom with PHP Version = '.phpversion() .' >= 5.3<br/>'
                   . 'In this case the Symbolic Link feature is only available with Windows Vista, Windows 7, Server 2008 or higher.</td></tr>'
                   ;
            }
            else {
               echo '<tr><td align="right">Symbolic Link is</td>';
               echo '<td>';
               echo '<font color="red">Forbidden</font><br/>';
               echo 'Only the mapping in the same directory will be available<br/>';
               echo "</td></tr>";
            }
         }
         else {
?>
<tr><td align="right">Symbolic Link is</td><td><b><font color="green">PRESENT</font></b> on <?php 
if ( strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
   echo 'Windows platform';
}
else{
   echo 'Linux platform';
}
?></td></tr>
</table>
For more information on how to use this script, see <a href="http://www.jms2win.com/index.php?option=com_content&view=article&id=75">Joomla Multi Sites - How to test DNS configuration</a>
<h2>Test Symbolic Link usage</h2>
The following test is only <font color="red"><b>required when</b></font> the DNS of the slave site is <font color="red"><b>NOT</b></font> mapped into the <font color="red"><b>SAME directory than</b></font> the <font color="red"><b>master website</b></font>.<br/>
If you have correctly mapped the <font color="DarkTurquoise" size="4"><b>slave sites</b></font> to the <font color="DarkTurquoise" size="4"><b>same path</b></font> than the <font color="DarkTurquoise" size="4"><b>master directory</b></font> [<?php echo $cur_dir; ?>] then this <font color="DarkTurquoise" size="4"><b>test is not required</b></font>.<br>
<br/>
The objective of the following test is to create a symbolic link in the path you will provide and verify that this functionality is authorized by your server.<br/>
<br/>
Enter the <b>FULL directory path</b> of your <b>slave sites</b> in the hereafter field when it is located into another directory than the master website.<br/>
This will create a link <b>"master_link"</b> in this directory and will allow you to check if the Symbolic Link feature of Joomla Multi Sites can be used in your specific case.<br/>
The operations consists in:
<ul>
   <li>a test if the slave path you have entered exists;</li>
   <li>Change of directory to use the slave path you have entered as current directory;</li>
   <li>Create a symbolic link called <b>"master_link"</b> that point to this "hello.php" directory.</li>
</ul>
The result of this operation is that a link is created into the slave domain and this link references the master domain path.<br/>
With this link you check its usage with a URL like "http://www.slave.com<b>/master_link</b>/hello.txt"<br/>
If this operation works and you can see the text "Hello world" text, this means that you can use the Symbolic Link feature that is present in Joomla Multi Sites.<br>
If you are not sure on how to analyze the result, don't hesitate to contact us.<br/>
<b><u>Remark:</u></b><br/>The symbolic link is not automatically deleted.<br/>
You can also use this "hello.php" script to delete the "master_link" OR you can delete it manually with a FTP connect, telnet connection, SSH connection, ....
<br/>
<br/>

<form action="" method="post" name="adminForm">
   Enter the full path of the slave site:<br/>
   <input type="text" name="slave_path" id="slave_path" size="80" maxlength="255" value=""/>
   <br/>
   <input type="submit" name="submit" value="Create master_link"/>
   <input type="submit" name="submit" value="Delete master_link"/>
</form>
<?php         
   
            // Remove Symbolic Link
            $fullname = $cur_dir .DIRECTORY_SEPARATOR. $link;
            if ( file_exists( $fullname)) {
               unlink( $fullname);
            }
         }
         
         // Remove Temporary file
         if ( !empty( $_REQUEST['temp']) && $_REQUEST['temp']=='keep') {}
         else {
            unlink( $tmp_fname);
         }
      }
   }
}


//------------ create_master_link ---------------
function create_master_link( $aSlavePath)
{
   $slave_dir = rtrim( $aSlavePath, '/');
   // Check the directory exists
   if ( !is_dir( $slave_dir)) {
      echo "The directory [$slave_dir] does NOT exists<br/>";
      return;
   }
   $cur_dir = getcwd();
   
   $fullname = $slave_dir . '/master_link';
   if ( is_link( $fullname)) {
      echo "The link already exists<br/>";
   }
   else {
      chdir( $slave_dir);
      $dir = getcwd();
      if ( $dir != $slave_dir) {
         echo "Unable to change the directory on $slave_dir<br/>";
         return;
      }
      $link = "master_link";
      if ( !symlink( $cur_dir, $link)) {
         echo "Unable to create a symbolic link [$link] -> [$cur_dir] in directory [$dir]<br/>";
      }
      else {
         echo "The creation of the <b>'master_link'</b> directory is successfull<br/>";
         echo "You have now a link [$slave_dir/$link] -> [$cur_dir]<br/>";
         echo "You can try to use the URL like  http://www.slave.com<b>/master_link/</b>hello.txt<br/>";
      }
   }
}

//------------ delete_master_link ---------------
function delete_master_link( $aSlavePath)
{
   $fullname = rtrim( $aSlavePath, '/') . '/master_link';
   // Check if the path is a folder (expected) or a file AND if this is a Symbolic Link
   if ( (file_exists( $fullname) || is_dir( $fullname))
     && is_link( $fullname)
      ) 
   {
      // In this case, delete the link
      if ( !unlink( $fullname)) {
         echo "Unable to delete the link [$fullname]<br/>";
      }
      else {
         echo "The link [$fullname] is sucessfully DELETED<br/>";
      }
   }
   else {
      echo "The link [$fullname] does NOT exists";
   }
}

// ===========================
//         MAIN
// ===========================
if ( !empty( $_REQUEST['slave_path'])) {
// echo var_export( $_REQUEST, true);
   if ( $_REQUEST['submit'] == 'Delete master_link') {
      delete_master_link( $_REQUEST['slave_path']);   
   }
   else {
      create_master_link( $_REQUEST['slave_path']);   
   }
}
else {
   hello_word();
}


?>