<?php
/**
 * @file       sr2win.php
 * @brief      System Plugin that allow Search And Replace any string after Content Rendering.
 * @version    1.10.04
 * @author     Edwin CHERONT     (e.cheront@jms2win.com)
 *             Edwin2Win sprlu   (www.jms2win.com)
 * @copyright  Joomla Multi Sites
 *             Single Joomla! 1.5.x installation using multiple configuration (One for each 'slave' sites).
 *             (C) 2008-2021 Edwin2Win srl - all right reserved.
 * @license    This program is free software; you can redistribute it and/or
 *             modify it under the terms of the GNU General Public License
 *             as published by the Free Software Foundation; either version 2
 *             of the License, or (at your option) any later version.
 *             This program is distributed in the hope that it will be useful,
 *             but WITHOUT ANY WARRANTY; without even the implied warranty of
 *             MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *             GNU General Public License for more details.
 *             You should have received a copy of the GNU General Public License
 *             along with this program; if not, write to the Free Software
 *             Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *             A full text version of the GNU GPL version 2 can be found in the LICENSE.php file.
 * @par History:
 * - V1.0.0 07-MAR-2009: File creation
 * - V1.1.0 25-FEB-2010: Add possibilty to process regular expression.
 *                       Start the expression with a ~ to specify that you want process it as a regular Search/Replace
 * - V1.2.0 30-JUL-2010: Add the possibility to get the list of Search/Replace expressions from file.
 * - V1.3.0 07-MAR-2011: Add Joomla 1.6 compatibility.
 * - V1.4.0 03-JUL-2011: Add processing of keywords {host-1}, ..., {host-5} that are replaced by the value
 *                       of the host domain parameter.
 *                       http://host-5.host-4.host-3.host-2.host-1/xxx
 * - V1.5.0 04-NOV-2011: Add PCRE customization and error handling with
 *                       then contribution of "Konstantin Ignatov" (AKA e-kinst)
 * - V1.6.0 10-MAY-2012: Fix calling _regExProcess() by reference that is now a Fatal Error on PHP 5.4
 * - V1.7.0 15-MAR-2013: Add Joomla 3.0 & 3.1 compatibility - updated the manifest file
 * - V1.8.0 17-MAR-2013: Add the possibility to use the {host} and {host-x} into the S/R file name
 * - V1.9.0 19-MAR-2013: Add the possibility to decide where, in an HTML page, the S/R must be applied (all html, header only, body only).
 * - V1.10.01 01-OCT-2014: Remove a PHP Strict message for compatibility with J1.6+ (or higher).
 * - V1.10.02 23-APR-2019: Remove a PHP 4.3 compatibility (constructor with same name) to remove PHP 7.x Deprecated message.
 * - V1.10.03 29-SEP-2021: Add Joomla 4.0 compatibility. Remove JFile and replace by native PHP. Replace JResponse by call to "this" JApplication.
 *                         Compatible with PHP 7.4 and PHP 8
 * - V1.10.04 19-DEC-2021: Add the Joomla Update System in the manifest
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.filesystem.file');
jimport( 'joomla.plugin.plugin' );


class plgSystemSR2Win extends JPlugin
{

	var $_db = null;

   //------------ onAfterInitialise ---------------
	/**
     * Apply the processing on the environment vairables
     */
	function onAfterInitialise()
	{
      $sr_applyonurl  = $this->params->get("sr_applyonurl", 0) == 1;
      
      if ( !$sr_applyonurl) {
         return true;
      }
      
      return $this->doSearchReplace( true);
	}

   //------------ onAfterRender ---------------
	/**
     * Converting the site URL to fit to the HTTP request
     */
	function onAfterRender()
	{
	   $this->doSearchReplace();
	}

   //------------ onAfterRender ---------------
	/**
     * Converting the site URL to fit to the HTTP request
     */
	function doSearchReplace( $ApplyOnURL=false)
	{
		$app = JFactory::getApplication();

      $scope  = $this->params->get("sr_scope", 'site');  // By default, the SearchReplace is only active for the front-end 

		// If scope match then OK
		if ( $app->getName() == $scope) {}
		// If always processed then OK
		else if ( $scope == 'always') {}
		// Otherwise, discard the processing
		else {
			return true;
		}

      $sr_applyonhead  = $this->params->get("sr_applyonhead", 1) == 1;
      $sr_applyonbody  = $this->params->get("sr_applyonbody", 1) == 1;

      // When both Head & Body is enabled the scope is ALL (just in case where there is comment outside of these sections
      $sr_applyonALL = $sr_applyonhead & $sr_applyonbody;

		// J1.5 -> J3.x
		if ( class_exists( 'JResponse')) {
		   $buffer = JResponse::getBody();
		}
		// J4.0
		else {
		   $buffer = $app->getBody();
		}
		
		// When not ALL page
		if ( $sr_applyonALL) {}
		else {
		   // Extract the head and body section
		   $ucBuf = strtoupper( $buffer);
		   $head_pos_begin = strpos( $ucBuf, '<HEAD>');
		   if ( $head_pos_begin !== false) {
		      $head_pos_end = strpos( $ucBuf, '</HEAD>', $head_pos_begin);
   		   if ( $head_pos_end !== false) {
   		      $head_pos_end += 7;
      		   $body_pos_begin = strpos( $ucBuf, '<BODY', $head_pos_end);
      		   if ( $body_pos_begin !== false) {
      		      $body_pos_end = strlen( $ucBuf);
      		      for ( ; $body_pos_end>$body_pos_begin && substr( $ucBuf, $body_pos_end, 7) != '</BODY>'; $body_pos_end--);
      		      
      		      if ( $body_pos_end>$body_pos_begin) {
      		         $body_pos_end += 7;
      		      }
      		      // If not found
      		      else {
      		         // Go to the end
         		      $body_pos_end = strlen( $ucBuf);
      		      }
      		   }
      		   // Body section not present
      		   else {
      		      $body_pos_begin = $head_pos_end + 7;
      		   }
   		   }
   		   // </head> not found
   		   else {
      		   $body_pos_begin = strpos( $ucBuf, '<BODY', $head_pos_end);
      		   if ( $body_pos_begin !== false) {
      		      // Use the <body..> to mark the end of the <head>
         		   $head_pos_end = $body_pos_begin -1;
      		      $body_pos_end = strlen( $ucBuf);
      		      for ( ; $body_pos_end>$body_pos_begin && substr( $ucBuf, $body_pos_end, 7) != '</BODY>'; $body_pos_end--);
      		      
      		      if ( $body_pos_end>$body_pos_begin) {
      		         $body_pos_end += 7;
      		      }
      		      // If not found
      		      else {
      		         // Go to the end
         		      $body_pos_end = strlen( $ucBuf);
      		      }
      		   }
      		   // </head> and <body> section not present
      		   else {
      		      // error => switch to process ALL
      		      $sr_applyonALL = true;
      		   }
   		   }
		   }
		   // <head> is not present
		   else {
		      // Start from 0
   		   $head_pos_begin = 0;
   		   // And use the <body> as end section
   		   $head_pos_end   =
   		   $body_pos_begin = strpos( $ucBuf, '<BODY');
   		   if ( $body_pos_begin !== false) {
   		      $body_pos_end = strlen( $ucBuf);
   		      for ( ; $body_pos_end>$body_pos_begin && substr( $ucBuf, $body_pos_end, 7) != '</BODY>'; $body_pos_end--);
   		      
   		      if ( $body_pos_end>$body_pos_begin) {
   		         $body_pos_end += 7;
   		      }
   		      // If not found
   		      else  {
   		         // Go to the end
      		      $body_pos_end = strlen( $ucBuf);
   		      }
   		   }
   		   // </head> and <body> section not present
   		   else {
   		      // error => switch to process ALL
   		      $sr_applyonALL = true;
   		   }
		   }
		   
		   $begin         = ($head_pos_begin > 0)             ? substr( $buffer, 0, $head_pos_begin)                                    : '';
		   $head_buffer   = ($head_pos_end > $head_pos_begin) ? substr( $buffer, $head_pos_begin, $head_pos_end   - $head_pos_begin +1) : '';
		   $middle        = ($body_pos_begin > $head_pos_end) ? substr( $buffer, $head_pos_end,   $body_pos_begin - $head_pos_end)      : '';
		   $body_buffer   = ($body_pos_end > $body_pos_begin) ? substr( $buffer, $body_pos_begin, $body_pos_end   - $body_pos_begin +1) : '';
		   $end           = (strlen( $buffer) > $body_pos_end)? substr( $buffer, $body_pos_end)                                         : '';
		}
		
		
		// ------ Compute the {host-n} keywords ----
		$host_search  = array();
		$host_replace = array_reverse( explode( '.', $_SERVER['HTTP_HOST']));
		if ( !empty($host_replace) && is_array( $host_replace)) {
   		for ( $i=0; $i<count($host_replace); $i++) {
   		   $host_search[$i] = '{host-'.($i+1).'}';
   		}
   	}

      // ------ Read Plugin Parameters ----
      $sr_list  = $this->params->get("sr_list", '');
      $this->_loadFile( $sr_list, 'sr_file1', $host_search, $host_replace);
      $this->_loadFile( $sr_list, 'sr_file2', $host_search, $host_replace);

      $lines         = explode( "\n", $sr_list);
   	$searchs       = array();
   	$replaces      = array();
   	$expsearchs    = array();
   	$expreplaces   = array();
      foreach( $lines as $line) {
         $line = trim( $line);
         // Skip empty lines
         if ( empty( $line)) {
            continue;
         }

         // If comment
         if ( substr( $line, 0, 1) == ';') {
         	continue;
         }
         
         // Update the "line" with the "{host-x}" keywords
			if ( !empty( $host_search)) {
   			$line = str_replace( $host_search, $host_replace, $line);
			}
         
         // If regexp
         if ( substr( $line, 0, 1) == '~') {
         	if ( !empty( $searchs)) {
               if ( $ApplyOnURL) {
         			$_SERVER["PHP_SELF"] = str_replace( $searchs, $replaces, $_SERVER["PHP_SELF"]);
         			$_SERVER['SCRIPT_NAME'] = str_replace( $searchs, $replaces, $_SERVER['SCRIPT_NAME']);
               }
               // If scope is ALL
               else if ( $sr_applyonALL) {
         			$buffer = str_replace( $searchs, $replaces, $buffer);
               }
               else {
                  // If Head Section only
                  if ( $sr_applyonhead) {
            			$head_buffer = str_replace( $searchs, $replaces, $head_buffer);
                  }
                  // If Body Section only
                  if ( $sr_applyonbody) {
            			$body_buffer = str_replace( $searchs, $replaces, $body_buffer);
                  }
               }
         	}
         	$searchs  = array();
         	$replaces = array();
         	
            $line       = trim( substr( $line, 1));
            $separator  = substr( $line, 0, 1);
   		   $p0 = strpos( $line, $separator, 1);      // Search for closing separator (the second one)
   		   if ( $p0 === false) {
   		      continue;
   		   }
            // Parse statment search=replace
   		   $p1 = strpos( $line, '=', $p0);
   		   if ( $p1 === false) {
   		      continue;
   		   }
   		   
   		   $s = trim( substr( $line, 0, $p1));
   		   $r = trim( substr( $line, $p1+1));
   		   if ( !empty( $s)) {
   		   	$expsearchs[]  = $s;
   		   	$expreplaces[] = $r;
   		   }
   		   
         }
         // If not RegExp
         else {
         	// If a previous regexp SR is present
         	if ( !empty( $expsearchs)) {
               if ( $ApplyOnURL) {
         			$_SERVER["PHP_SELF"] = preg_replace( $expsearchs, $expreplaces, $_SERVER["PHP_SELF"]);
         			$_SERVER['SCRIPT_NAME'] = preg_replace( $expsearchs, $expreplaces, $_SERVER['SCRIPT_NAME']);
               }
               // If scope is ALL
               else if ( $sr_applyonALL) {
                  // Call specific regular expression in case or error and add possibility of reporting.
         			if( $this->_regExProcess( $buffer, $expsearchs, $expreplaces) != PREG_NO_ERROR ) {
         			   // In case of error, stop the processing
         			   break;
         			}
               }
               else if ( $sr_applyonhead || $sr_applyonbody) {
                  // If Head Section only
                  if ( $sr_applyonhead) {
                     // Call specific regular expression in case or error and add possibility of reporting.
            			if( $this->_regExProcess( $head_buffer, $expsearchs, $expreplaces) != PREG_NO_ERROR ) {
            			   // In case of error, stop the processing
            			   break;
            			}
                  }
                  // If Body Section only
                  if ( $sr_applyonbody) {
                     // Call specific regular expression in case or error and add possibility of reporting.
            			if( $this->_regExProcess( $body_buffer, $expsearchs, $expreplaces) != PREG_NO_ERROR ) {
            			   // In case of error, stop the processing
            			   break;
            			}
                  }
               }
               else {
               }
            	$expsearchs    = array();
            	$expreplaces   = array();
         	}
         	
            // Parse statment search=replace
   		   $p1 = strpos( $line, '=');
   		   if ( $p1 === false) {
   		      continue;
   		   }
   		   
   		   $s = trim( substr( $line, 0, $p1));
   		   $r = trim( substr( $line, $p1+1));
   		   if ( !empty( $s)) {
   		   	$searchs[]  = $s;
   		   	$replaces[] = $r;
   		   }
         }
      } // End of loop
      
      // Process the remaining S/R rules
      if ( $ApplyOnURL) {
      	if ( !empty( $searchs)) {
   			$_SERVER["PHP_SELF"]    = str_replace( $searchs, $replaces, $_SERVER["PHP_SELF"]);
   			$_SERVER['SCRIPT_NAME'] = str_replace( $searchs, $replaces, $_SERVER['SCRIPT_NAME']);
      	}
      	if ( !empty( $expsearchs)) {
   			$_SERVER["PHP_SELF"]    = preg_replace( $expsearchs, $expreplaces, $_SERVER["PHP_SELF"]);
   			$_SERVER['SCRIPT_NAME'] = preg_replace( $expsearchs, $expreplaces, $_SERVER['SCRIPT_NAME']);
      	}
      }
      else {
      	if ( !empty( $searchs)) {
            // If scope is ALL
            if ( $sr_applyonALL) {
      			$buffer = str_replace( $searchs, $replaces, $buffer);
            }
            else {
               // If Head Section only
               if ( $sr_applyonhead) {
         			$head_buffer = str_replace( $searchs, $replaces, $head_buffer);
               }
               // If Body Section only
               if ( $sr_applyonbody) {
         			$body_buffer = str_replace( $searchs, $replaces, $body_buffer);
               }
            }
      	}
      	if ( !empty( $expsearchs)) {
            // If scope is ALL
            if ( $sr_applyonALL) {
         	   // Call specific regular expression to manage the error and avoid empty page
         		$this->_regExProcess( $buffer, $expsearchs, $expreplaces);
            }
            else {
               // If Head Section only
               if ( $sr_applyonhead) {
            		$this->_regExProcess( $head_buffer, $expsearchs, $expreplaces);
               }
               // If Body Section only
               if ( $sr_applyonbody) {
            		$this->_regExProcess( $body_buffer, $expsearchs, $expreplaces);
               }
            }
      	}
   
   		// ---- Produce the output ----
         if ( $sr_applyonALL) {
      		// J1.5 -> J3.x
      		if ( class_exists( 'JResponse')) {
         		JResponse::setBody($buffer);
         	}
         	// J4.0
         	else {
		         $app->setBody($buffer);
         	}
      	}
      	else {
      	   $buffer = $begin
      	           . $head_buffer
      	           . $middle
      	           . $body_buffer
      	           . $end
      	           ;
      		// J1.5 -> J3.x
      		if ( class_exists( 'JResponse')) {
         		JResponse::setBody($buffer);
         	}
         	// J4.0
         	else {
		         $app->setBody($buffer);
         	}
      	}
      }


		return true;
	}

   //------------ _loadFile ---------------
	function _loadFile( &$sr_list, $sr_fileX, $host_search, $host_replace)
	{
      $sr_file  = $this->params->get( $sr_fileX, '');
      if ( !empty( $sr_file)) {

   	   if ( defined( 'JPATH_ROOT'))  { $jpath_root = JPATH_ROOT; }
   	   else                          { $jpath_root = dirname( dirname( dirname(__FILE__))); }

         $site_id = '';
         if ( defined( 'MULTISITES_ID')) {
            $sr_dot  = $this->params->get("sr_dot", 1);
            if ( $sr_dot == 1) { $site_id = '.'; }
            $site_id .=  MULTISITES_ID;
         }
         
         
         $search_keywords  = array( '{root}', '{site_id}', '{host}');
         $replace_keywords = array( $jpath_root, $site_id, $_SERVER['HTTP_HOST']);

			$filename = str_replace( $search_keywords, $replace_keywords, $sr_file);
			$filename = str_replace( $host_search, $host_replace, $filename);
			if ( file_exists( $filename)) {
   			// $file_list = JFile::read( $filename);
   			$file_list = file_get_contents( $filename);
   			// If there is something in the files
   			if ( !empty( $file_list)) {
   			   // Append the file list to the current list and put a new line between both list
   			   $sr_list .= "\n"
   			            .  $file_list
   			            ;
   			}
			}
      }
	}

   //------------ _regExProcess ---------------
   /**
    * @brief Process the regular expression and in case or error
    */
	function _regExProcess(&$buffer, &$expsearchs, &$expreplaces)
	{
      // Read the "Advanced" parameters (PCRE)
      $sr_err  = $this->params->get("sr_err", ''); // RegEx error behavior

      $sr_re   = $this->params->get("sr_re", '');  // RegEx limits set and check it has 6 or 7 digits
      $arr     = array();
      $sr_re   = ($sr_re && preg_match('#^\s*(\d{6,7})\s*$#', $sr_re, $arr))? $arr[1] : 0;

      # ****** $buffer may be large enough beacause it's whole page HTML
      #				So lets try to have PREG parameters large enough too
      $bytes   = mb_strlen($buffer,'8bit');
      
      // Configure the "backtrack limit"
      $btLimit = ini_get('pcre.backtrack_limit');
      // If the PCRE limit is lower that 2.05 time the number of bytes in the buffer to process
      // and that a new limit is provided with a higher value
      if( $btLimit < 2.05*$bytes  &&  $btLimit < $sr_re ) {
         // Then set the new backtrack_limit with the one provided in parameter
         ini_set('pcre.backtrack_limit', $sr_re);
      }
      else {
         // Otherwise, don't changed anything
         $btLimit = 0;
      }

      // Configure the "recursion limit"
      $rLimit = ini_get('pcre.recursion_limit');
      if( $rLimit < 2.05*$bytes  &&  $rLimit < $sr_re ) {
         // Set a new "recursion limit" with the one provided in paramter
         ini_set('pcre.recursion_limit', $sr_re);
      }
      else {
         // Otherwise, don't changed anything
         $rLimit = 0;
      }
      
      // Process the regular expression
      $bufNew  = preg_replace( $expsearchs, $expreplaces, $buffer);
      $errCode = preg_last_error();
      
      // When OK
      if( $errCode == PREG_NO_ERROR ) {
         // Return the result present in the new buffer
         $buffer = $bufNew;
      }
      // When Error
      else {
         // If there is a special error processing
         if( $sr_err ) {
            // Replace the page by an error page with different level of reporting.
            $chars = mb_strlen( $buffer,'utf8');
      		$buffer = '<html><body>SR plugin: RegEx error: ';
      		// If show detailed error is requested
   	   	if( $sr_err == 2 ) {
               switch( $errCode )
               {
                  case PREG_INTERNAL_ERROR:        { $buffer .= 'PREG_INTERNAL_ERROR'; break; }
                  case PREG_BACKTRACK_LIMIT_ERROR: { $buffer .= 'PREG_BACKTRACK_LIMIT_ERROR'; break; }
                  case PREG_RECURSION_LIMIT_ERROR: { $buffer .= 'PREG_RECURSION_LIMIT_ERROR'; break; }
                  case PREG_BAD_UTF8_ERROR:        { $buffer .= 'PREG_BAD_UTF8_ERROR'; break; }
                  case PREG_BAD_UTF8_OFFSET_ERROR: { $buffer .= 'PREG_BAD_UTF8_OFFSET_ERROR'; break; }
                  default:                         { $buffer .= 'PREG ERROR ' . $errCode; break; }
               }
               
               // Display PCRE detailled informations
               $buffer .= '<br />pcre.backtrack_limit = ' . ini_get('pcre.backtrack_limit');
               $buffer .= '<br />pcre.recursion_limit = ' . ini_get('pcre.recursion_limit');
               $buffer .= "<br />String length = $chars chars ($bytes bytes)<br />";
               $buffer .= '<br />' . implode('<br />', $expsearchs) . '<br />';
               $buffer .= '<br />' . implode('<br />', $expreplaces);
    			}
    			else {
    			   $buffer .= 'PREG ERROR ' . $errCode;
    			}
    	      $buffer .= '</body></html>';
      	}
      }
      $expsearchs    = array();		# this means 'no RegEx pending'
      $expreplaces   = array();
      
      // restore the original value in case where they were changed
      $btLimit and  ini_set('pcre.backtrack_limit', $btLimit);
      $rLimit  and  ini_set('pcre.recursion_limit', $rLimit);
      
      return( $errCode);
	}

} // End class
